/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class RegisterTargetsRequestMarshaller
implements Marshaller<Request<RegisterTargetsRequest>, RegisterTargetsRequest> {
    public Request<RegisterTargetsRequest> marshall(RegisterTargetsRequest registerTargetsRequest) {
        List<TargetDescription> targetsList;
        if (registerTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)registerTargetsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "RegisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerTargetsRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)registerTargetsRequest.targetGroupArn()));
        }
        if ((targetsList = registerTargetsRequest.targets()) != null) {
            if (!targetsList.isEmpty()) {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue.id() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString((String)targetsListValue.id()));
                    }
                    if (targetsListValue.port() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger((Integer)targetsListValue.port()));
                    }
                    if (targetsListValue.availabilityZone() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringUtils.fromString((String)targetsListValue.availabilityZone()));
                    }
                    ++targetsListIndex;
                }
            } else {
                request.addParameter("Targets", "");
            }
        }
        return request;
    }
}

