/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class DeregisterTargetsRequestMarshaller
implements Marshaller<Request<DeregisterTargetsRequest>, DeregisterTargetsRequest> {
    public Request<DeregisterTargetsRequest> marshall(DeregisterTargetsRequest deregisterTargetsRequest) {
        List<TargetDescription> targetsList;
        if (deregisterTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deregisterTargetsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DeregisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deregisterTargetsRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)deregisterTargetsRequest.targetGroupArn()));
        }
        if ((targetsList = deregisterTargetsRequest.targets()) != null) {
            if (!targetsList.isEmpty()) {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue.id() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString((String)targetsListValue.id()));
                    }
                    if (targetsListValue.port() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger((Integer)targetsListValue.port()));
                    }
                    if (targetsListValue.availabilityZone() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringUtils.fromString((String)targetsListValue.availabilityZone()));
                    }
                    ++targetsListIndex;
                }
            } else {
                request.addParameter("Targets", "");
            }
        }
        return request;
    }
}

