/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.LoadBalancerAddressUnmarshaller;

public class AvailabilityZoneUnmarshaller
implements Unmarshaller<AvailabilityZone, StaxUnmarshallerContext> {
    private static final AvailabilityZoneUnmarshaller INSTANCE = new AvailabilityZoneUnmarshaller();

    public AvailabilityZone unmarshall(StaxUnmarshallerContext context) throws Exception {
        AvailabilityZone.Builder availabilityZone;
        block7: {
            availabilityZone = AvailabilityZone.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<LoadBalancerAddress> loadBalancerAddresses = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    availabilityZone.loadBalancerAddresses(loadBalancerAddresses);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ZoneName", targetDepth)) {
                        availabilityZone.zoneName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SubnetId", targetDepth)) {
                        availabilityZone.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LoadBalancerAddresses", targetDepth)) {
                        loadBalancerAddresses = new ArrayList<LoadBalancerAddress>();
                        continue;
                    }
                    if (!context.testExpression("LoadBalancerAddresses/member", targetDepth)) continue;
                    loadBalancerAddresses.add(LoadBalancerAddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            availabilityZone.loadBalancerAddresses(loadBalancerAddresses);
        }
        return (AvailabilityZone)availabilityZone.build();
    }

    public static AvailabilityZoneUnmarshaller getInstance() {
        return INSTANCE;
    }
}

