/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetSubnetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetSubnetsRequest> {
    private final String loadBalancerArn;
    private final List<String> subnets;
    private final List<SubnetMapping> subnetMappings;

    private SetSubnetsRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.subnetMappings(), other.subnetMappings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.subnetMappings() != null) {
            sb.append("SubnetMappings: ").append(this.subnetMappings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.of(clazz.cast(this.loadBalancerArn()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "SubnetMappings": {
                return Optional.of(clazz.cast(this.subnetMappings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> subnets;
        private List<SubnetMapping> subnetMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsRequest model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.subnets(model.subnets);
            this.subnetMappings(model.subnetMappings);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final Collection<SubnetMapping.Builder> getSubnetMappings() {
            return this.subnetMappings != null ? (Collection)this.subnetMappings.stream().map(SubnetMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        public SetSubnetsRequest build() {
            return new SetSubnetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetSubnetsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);
    }
}

