/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetHealthResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTargetHealthResponse> {
    private final List<TargetHealthDescription> targetHealthDescriptions;

    private DescribeTargetHealthResponse(BuilderImpl builder) {
        this.targetHealthDescriptions = builder.targetHealthDescriptions;
    }

    public List<TargetHealthDescription> targetHealthDescriptions() {
        return this.targetHealthDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetHealthDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthResponse)) {
            return false;
        }
        DescribeTargetHealthResponse other = (DescribeTargetHealthResponse)((Object)obj);
        return Objects.equals(this.targetHealthDescriptions(), other.targetHealthDescriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetHealthDescriptions() != null) {
            sb.append("TargetHealthDescriptions: ").append(this.targetHealthDescriptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetHealthDescriptions": {
                return Optional.of(clazz.cast(this.targetHealthDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetHealthDescription> targetHealthDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetHealthResponse model) {
            this.targetHealthDescriptions(model.targetHealthDescriptions);
        }

        public final Collection<TargetHealthDescription.Builder> getTargetHealthDescriptions() {
            return this.targetHealthDescriptions != null ? (Collection)this.targetHealthDescriptions.stream().map(TargetHealthDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetHealthDescriptions(Collection<TargetHealthDescription> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copy(targetHealthDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetHealthDescriptions(TargetHealthDescription ... targetHealthDescriptions) {
            this.targetHealthDescriptions(Arrays.asList(targetHealthDescriptions));
            return this;
        }

        public final void setTargetHealthDescriptions(Collection<TargetHealthDescription.BuilderImpl> targetHealthDescriptions) {
            this.targetHealthDescriptions = TargetHealthDescriptionsCopier.copyFromBuilder(targetHealthDescriptions);
        }

        public DescribeTargetHealthResponse build() {
            return new DescribeTargetHealthResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTargetHealthResponse> {
        public Builder targetHealthDescriptions(Collection<TargetHealthDescription> var1);

        public Builder targetHealthDescriptions(TargetHealthDescription ... var1);
    }
}

