/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetHealthRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeTargetHealthRequest> {
    private final String targetGroupArn;
    private final List<TargetDescription> targets;

    private DescribeTargetHealthRequest(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targets = builder.targets;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public List<TargetDescription> targets() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthRequest)) {
            return false;
        }
        DescribeTargetHealthRequest other = (DescribeTargetHealthRequest)((Object)obj);
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.targets(), other.targets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.targetGroupArn()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private List<TargetDescription> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetHealthRequest model) {
            this.targetGroupArn(model.targetGroupArn);
            this.targets(model.targets);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Collection<TargetDescription.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(TargetDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<TargetDescription> targets) {
            this.targets = TargetDescriptionsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetDescription ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<TargetDescription.BuilderImpl> targets) {
            this.targets = TargetDescriptionsCopier.copyFromBuilder(targets);
        }

        public DescribeTargetHealthRequest build() {
            return new DescribeTargetHealthRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTargetHealthRequest> {
        public Builder targetGroupArn(String var1);

        public Builder targets(Collection<TargetDescription> var1);

        public Builder targets(TargetDescription ... var1);
    }
}

