/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRulesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRulesResponse> {
    private final List<Rule> rules;
    private final String nextMarker;

    private DescribeRulesResponse(BuilderImpl builder) {
        this.rules = builder.rules;
        this.nextMarker = builder.nextMarker;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesResponse)) {
            return false;
        }
        DescribeRulesResponse other = (DescribeRulesResponse)((Object)obj);
        return Objects.equals(this.rules(), other.rules()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Rule> rules;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesResponse model) {
            this.rules(model.rules);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<Rule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeRulesResponse build() {
            return new DescribeRulesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRulesResponse> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder nextMarker(String var1);
    }
}

