/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateLoadBalancerRequest> {
    private final String name;
    private final List<String> subnets;
    private final List<SubnetMapping> subnetMappings;
    private final List<String> securityGroups;
    private final String scheme;
    private final List<Tag> tags;
    private final String type;
    private final String ipAddressType;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
        this.securityGroups = builder.securityGroups;
        this.scheme = builder.scheme;
        this.tags = builder.tags;
        this.type = builder.type;
        this.ipAddressType = builder.ipAddressType;
    }

    public String name() {
        return this.name;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(this.scheme);
    }

    public String schemeString() {
        return this.scheme;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public String ipAddressTypeString() {
        return this.ipAddressType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.schemeString(), other.schemeString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.ipAddressTypeString(), other.ipAddressTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.subnetMappings() != null) {
            sb.append("SubnetMappings: ").append(this.subnetMappings()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.schemeString() != null) {
            sb.append("Scheme: ").append(this.schemeString()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.ipAddressTypeString() != null) {
            sb.append("IpAddressType: ").append(this.ipAddressTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "SubnetMappings": {
                return Optional.of(clazz.cast(this.subnetMappings()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "Scheme": {
                return Optional.of(clazz.cast(this.schemeString()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "IpAddressType": {
                return Optional.of(clazz.cast(this.ipAddressTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> subnets;
        private List<SubnetMapping> subnetMappings;
        private List<String> securityGroups;
        private String scheme;
        private List<Tag> tags;
        private String type;
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            this.name(model.name);
            this.subnets(model.subnets);
            this.subnetMappings(model.subnetMappings);
            this.securityGroups(model.securityGroups);
            this.scheme(model.scheme);
            this.tags(model.tags);
            this.type(model.type);
            this.ipAddressType(model.ipAddressType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final Collection<SubnetMapping.Builder> getSubnetMappings() {
            return this.subnetMappings != null ? (Collection)this.subnetMappings.stream().map(SubnetMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        public Builder name(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);
    }
}

