/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;

public class DescribeListenersRequestMarshaller
implements Marshaller<Request<DescribeListenersRequest>, DescribeListenersRequest> {
    public Request<DescribeListenersRequest> marshall(DescribeListenersRequest describeListenersRequest) {
        List<String> listenerArnsList;
        if (describeListenersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeListenersRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeListeners");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeListenersRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)describeListenersRequest.loadBalancerArn()));
        }
        if ((listenerArnsList = describeListenersRequest.listenerArns()) != null) {
            if (!listenerArnsList.isEmpty()) {
                int listenerArnsListIndex = 1;
                for (String listenerArnsListValue : listenerArnsList) {
                    if (listenerArnsListValue != null) {
                        request.addParameter("ListenerArns.member." + listenerArnsListIndex, StringUtils.fromString((String)listenerArnsListValue));
                    }
                    ++listenerArnsListIndex;
                }
            } else {
                request.addParameter("ListenerArns", "");
            }
        }
        if (describeListenersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeListenersRequest.marker()));
        }
        if (describeListenersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeListenersRequest.pageSize()));
        }
        return request;
    }
}

