/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthReasonEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthStateEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetHealth
implements ToCopyableBuilder<Builder, TargetHealth> {
    private final String state;
    private final String reason;
    private final String description;

    private TargetHealth(BuilderImpl builder) {
        this.state = builder.state;
        this.reason = builder.reason;
        this.description = builder.description;
    }

    public TargetHealthStateEnum state() {
        return TargetHealthStateEnum.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public TargetHealthReasonEnum reason() {
        return TargetHealthReasonEnum.fromValue(this.reason);
    }

    public String reasonString() {
        return this.reason;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.reasonString() == null ? 0 : this.reasonString().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealth)) {
            return false;
        }
        TargetHealth other = (TargetHealth)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.reasonString() == null ^ this.reasonString() == null) {
            return false;
        }
        if (other.reasonString() != null && !other.reasonString().equals(this.reasonString())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.reasonString() != null) {
            sb.append("Reason: ").append(this.reasonString()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Reason": {
                return Optional.of(clazz.cast(this.reasonString()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String reason;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealth model) {
            this.state(model.state);
            this.reason(model.reason);
            this.description(model.description);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TargetHealthStateEnum state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(TargetHealthReasonEnum reason) {
            this.reason(reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public TargetHealth build() {
            return new TargetHealth(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetHealth> {
        public Builder state(String var1);

        public Builder state(TargetHealthStateEnum var1);

        public Builder reason(String var1);

        public Builder reason(TargetHealthReasonEnum var1);

        public Builder description(String var1);
    }
}

