/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetGroup
implements ToCopyableBuilder<Builder, TargetGroup> {
    private final String targetGroupArn;
    private final String targetGroupName;
    private final String protocol;
    private final Integer port;
    private final String vpcId;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final String healthCheckPath;
    private final Matcher matcher;
    private final List<String> loadBalancerArns;

    private TargetGroup(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targetGroupName = builder.targetGroupName;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.healthCheckPath = builder.healthCheckPath;
        this.matcher = builder.matcher;
        this.loadBalancerArns = builder.loadBalancerArns;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public String targetGroupName() {
        return this.targetGroupName;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public List<String> loadBalancerArns() {
        return this.loadBalancerArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroupArn() == null ? 0 : this.targetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.targetGroupName() == null ? 0 : this.targetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.protocolString() == null ? 0 : this.protocolString().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckProtocolString() == null ? 0 : this.healthCheckProtocolString().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckPort() == null ? 0 : this.healthCheckPort().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckIntervalSeconds() == null ? 0 : this.healthCheckIntervalSeconds().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckTimeoutSeconds() == null ? 0 : this.healthCheckTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.healthyThresholdCount() == null ? 0 : this.healthyThresholdCount().hashCode());
        hashCode = 31 * hashCode + (this.unhealthyThresholdCount() == null ? 0 : this.unhealthyThresholdCount().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckPath() == null ? 0 : this.healthCheckPath().hashCode());
        hashCode = 31 * hashCode + (this.matcher() == null ? 0 : this.matcher().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerArns() == null ? 0 : this.loadBalancerArns().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroup)) {
            return false;
        }
        TargetGroup other = (TargetGroup)obj;
        if (other.targetGroupArn() == null ^ this.targetGroupArn() == null) {
            return false;
        }
        if (other.targetGroupArn() != null && !other.targetGroupArn().equals(this.targetGroupArn())) {
            return false;
        }
        if (other.targetGroupName() == null ^ this.targetGroupName() == null) {
            return false;
        }
        if (other.targetGroupName() != null && !other.targetGroupName().equals(this.targetGroupName())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        if (other.protocolString() != null && !other.protocolString().equals(this.protocolString())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.healthCheckProtocolString() == null ^ this.healthCheckProtocolString() == null) {
            return false;
        }
        if (other.healthCheckProtocolString() != null && !other.healthCheckProtocolString().equals(this.healthCheckProtocolString())) {
            return false;
        }
        if (other.healthCheckPort() == null ^ this.healthCheckPort() == null) {
            return false;
        }
        if (other.healthCheckPort() != null && !other.healthCheckPort().equals(this.healthCheckPort())) {
            return false;
        }
        if (other.healthCheckIntervalSeconds() == null ^ this.healthCheckIntervalSeconds() == null) {
            return false;
        }
        if (other.healthCheckIntervalSeconds() != null && !other.healthCheckIntervalSeconds().equals(this.healthCheckIntervalSeconds())) {
            return false;
        }
        if (other.healthCheckTimeoutSeconds() == null ^ this.healthCheckTimeoutSeconds() == null) {
            return false;
        }
        if (other.healthCheckTimeoutSeconds() != null && !other.healthCheckTimeoutSeconds().equals(this.healthCheckTimeoutSeconds())) {
            return false;
        }
        if (other.healthyThresholdCount() == null ^ this.healthyThresholdCount() == null) {
            return false;
        }
        if (other.healthyThresholdCount() != null && !other.healthyThresholdCount().equals(this.healthyThresholdCount())) {
            return false;
        }
        if (other.unhealthyThresholdCount() == null ^ this.unhealthyThresholdCount() == null) {
            return false;
        }
        if (other.unhealthyThresholdCount() != null && !other.unhealthyThresholdCount().equals(this.unhealthyThresholdCount())) {
            return false;
        }
        if (other.healthCheckPath() == null ^ this.healthCheckPath() == null) {
            return false;
        }
        if (other.healthCheckPath() != null && !other.healthCheckPath().equals(this.healthCheckPath())) {
            return false;
        }
        if (other.matcher() == null ^ this.matcher() == null) {
            return false;
        }
        if (other.matcher() != null && !other.matcher().equals(this.matcher())) {
            return false;
        }
        if (other.loadBalancerArns() == null ^ this.loadBalancerArns() == null) {
            return false;
        }
        return other.loadBalancerArns() == null || other.loadBalancerArns().equals(this.loadBalancerArns());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.targetGroupArn()).append(",");
        }
        if (this.targetGroupName() != null) {
            sb.append("TargetGroupName: ").append(this.targetGroupName()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.healthCheckProtocolString() != null) {
            sb.append("HealthCheckProtocol: ").append(this.healthCheckProtocolString()).append(",");
        }
        if (this.healthCheckPort() != null) {
            sb.append("HealthCheckPort: ").append(this.healthCheckPort()).append(",");
        }
        if (this.healthCheckIntervalSeconds() != null) {
            sb.append("HealthCheckIntervalSeconds: ").append(this.healthCheckIntervalSeconds()).append(",");
        }
        if (this.healthCheckTimeoutSeconds() != null) {
            sb.append("HealthCheckTimeoutSeconds: ").append(this.healthCheckTimeoutSeconds()).append(",");
        }
        if (this.healthyThresholdCount() != null) {
            sb.append("HealthyThresholdCount: ").append(this.healthyThresholdCount()).append(",");
        }
        if (this.unhealthyThresholdCount() != null) {
            sb.append("UnhealthyThresholdCount: ").append(this.unhealthyThresholdCount()).append(",");
        }
        if (this.healthCheckPath() != null) {
            sb.append("HealthCheckPath: ").append(this.healthCheckPath()).append(",");
        }
        if (this.matcher() != null) {
            sb.append("Matcher: ").append(this.matcher()).append(",");
        }
        if (this.loadBalancerArns() != null) {
            sb.append("LoadBalancerArns: ").append(this.loadBalancerArns()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "TargetGroupName": {
                return Optional.of(clazz.cast(this.targetGroupName()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "HealthCheckProtocol": {
                return Optional.of(clazz.cast(this.healthCheckProtocolString()));
            }
            case "HealthCheckPort": {
                return Optional.of(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.of(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.of(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.of(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.of(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "HealthCheckPath": {
                return Optional.of(clazz.cast(this.healthCheckPath()));
            }
            case "Matcher": {
                return Optional.of(clazz.cast(this.matcher()));
            }
            case "LoadBalancerArns": {
                return Optional.of(clazz.cast(this.loadBalancerArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String targetGroupName;
        private String protocol;
        private Integer port;
        private String vpcId;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private String healthCheckPath;
        private Matcher matcher;
        private List<String> loadBalancerArns;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroup model) {
            this.targetGroupArn(model.targetGroupArn);
            this.targetGroupName(model.targetGroupName);
            this.protocol(model.protocol);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.healthCheckPath(model.healthCheckPath);
            this.matcher(model.matcher);
            this.loadBalancerArns(model.loadBalancerArns);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final Collection<String> getLoadBalancerArns() {
            return this.loadBalancerArns;
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        public TargetGroup build() {
            return new TargetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetGroup> {
        public Builder targetGroupArn(String var1);

        public Builder targetGroupName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder healthCheckPath(String var1);

        public Builder matcher(Matcher var1);

        public Builder loadBalancerArns(Collection<String> var1);

        public Builder loadBalancerArns(String ... var1);
    }
}

