/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CiphersCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslProtocolsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SslPolicy
implements ToCopyableBuilder<Builder, SslPolicy> {
    private final List<String> sslProtocols;
    private final List<Cipher> ciphers;
    private final String name;

    private SslPolicy(BuilderImpl builder) {
        this.sslProtocols = builder.sslProtocols;
        this.ciphers = builder.ciphers;
        this.name = builder.name;
    }

    public List<String> sslProtocols() {
        return this.sslProtocols;
    }

    public List<Cipher> ciphers() {
        return this.ciphers;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sslProtocols() == null ? 0 : this.sslProtocols().hashCode());
        hashCode = 31 * hashCode + (this.ciphers() == null ? 0 : this.ciphers().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy)obj;
        if (other.sslProtocols() == null ^ this.sslProtocols() == null) {
            return false;
        }
        if (other.sslProtocols() != null && !other.sslProtocols().equals(this.sslProtocols())) {
            return false;
        }
        if (other.ciphers() == null ^ this.ciphers() == null) {
            return false;
        }
        if (other.ciphers() != null && !other.ciphers().equals(this.ciphers())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sslProtocols() != null) {
            sb.append("SslProtocols: ").append(this.sslProtocols()).append(",");
        }
        if (this.ciphers() != null) {
            sb.append("Ciphers: ").append(this.ciphers()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SslProtocols": {
                return Optional.of(clazz.cast(this.sslProtocols()));
            }
            case "Ciphers": {
                return Optional.of(clazz.cast(this.ciphers()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sslProtocols;
        private List<Cipher> ciphers;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SslPolicy model) {
            this.sslProtocols(model.sslProtocols);
            this.ciphers(model.ciphers);
            this.name(model.name);
        }

        public final Collection<String> getSslProtocols() {
            return this.sslProtocols;
        }

        @Override
        public final Builder sslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslProtocols(String ... sslProtocols) {
            this.sslProtocols(Arrays.asList(sslProtocols));
            return this;
        }

        public final void setSslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
        }

        public final Collection<Cipher.Builder> getCiphers() {
            return this.ciphers != null ? (Collection)this.ciphers.stream().map(Cipher::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ciphers(Collection<Cipher> ciphers) {
            this.ciphers = CiphersCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Cipher ... ciphers) {
            this.ciphers(Arrays.asList(ciphers));
            return this;
        }

        public final void setCiphers(Collection<Cipher.BuilderImpl> ciphers) {
            this.ciphers = CiphersCopier.copyFromBuilder(ciphers);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public SslPolicy build() {
            return new SslPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SslPolicy> {
        public Builder sslProtocols(Collection<String> var1);

        public Builder sslProtocols(String ... var1);

        public Builder ciphers(Collection<Cipher> var1);

        public Builder ciphers(Cipher ... var1);

        public Builder name(String var1);
    }
}

