/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTargetGroupsResponse> {
    private final List<TargetGroup> targetGroups;
    private final String nextMarker;

    private DescribeTargetGroupsResponse(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
        this.nextMarker = builder.nextMarker;
    }

    public List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroups() == null ? 0 : this.targetGroups().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsResponse)) {
            return false;
        }
        DescribeTargetGroupsResponse other = (DescribeTargetGroupsResponse)((Object)obj);
        if (other.targetGroups() == null ^ this.targetGroups() == null) {
            return false;
        }
        if (other.targetGroups() != null && !other.targetGroups().equals(this.targetGroups())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroups() != null) {
            sb.append("TargetGroups: ").append(this.targetGroups()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.of(clazz.cast(this.targetGroups()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsResponse model) {
            this.targetGroups(model.targetGroups);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<TargetGroup.Builder> getTargetGroups() {
            return this.targetGroups != null ? (Collection)this.targetGroups.stream().map(TargetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeTargetGroupsResponse build() {
            return new DescribeTargetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTargetGroupsResponse> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);

        public Builder nextMarker(String var1);
    }
}

