/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailabilityZone
implements ToCopyableBuilder<Builder, AvailabilityZone> {
    private final String zoneName;
    private final String subnetId;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.subnetId = builder.subnetId;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.zoneName() == null ? 0 : this.zoneName().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        if (other.zoneName() == null ^ this.zoneName() == null) {
            return false;
        }
        if (other.zoneName() != null && !other.zoneName().equals(this.zoneName())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        return other.subnetId() == null || other.subnetId().equals(this.subnetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.zoneName() != null) {
            sb.append("ZoneName: ").append(this.zoneName()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ZoneName": {
                return Optional.of(clazz.cast(this.zoneName()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String zoneName;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.zoneName(model.zoneName);
            this.subnetId(model.subnetId);
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailabilityZone> {
        public Builder zoneName(String var1);

        public Builder subnetId(String var1);
    }
}

