/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleConditionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyRuleRequest> {
    private final String ruleArn;
    private final List<RuleCondition> conditions;
    private final List<Action> actions;

    private ModifyRuleRequest(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.conditions = builder.conditions;
        this.actions = builder.actions;
    }

    public String ruleArn() {
        return this.ruleArn;
    }

    public List<RuleCondition> conditions() {
        return this.conditions;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleArn() == null ? 0 : this.ruleArn().hashCode());
        hashCode = 31 * hashCode + (this.conditions() == null ? 0 : this.conditions().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRuleRequest)) {
            return false;
        }
        ModifyRuleRequest other = (ModifyRuleRequest)((Object)obj);
        if (other.ruleArn() == null ^ this.ruleArn() == null) {
            return false;
        }
        if (other.ruleArn() != null && !other.ruleArn().equals(this.ruleArn())) {
            return false;
        }
        if (other.conditions() == null ^ this.conditions() == null) {
            return false;
        }
        if (other.conditions() != null && !other.conditions().equals(this.conditions())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        return other.actions() == null || other.actions().equals(this.actions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleArn() != null) {
            sb.append("RuleArn: ").append(this.ruleArn()).append(",");
        }
        if (this.conditions() != null) {
            sb.append("Conditions: ").append(this.conditions()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private List<RuleCondition> conditions;
        private List<Action> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRuleRequest model) {
            this.setRuleArn(model.ruleArn);
            this.setConditions(model.conditions);
            this.setActions(model.actions);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final Collection<RuleCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        public final void setConditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
        }

        public final Collection<Action> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
        }

        public ModifyRuleRequest build() {
            return new ModifyRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyRuleRequest> {
        public Builder ruleArn(String var1);

        public Builder conditions(Collection<RuleCondition> var1);

        public Builder conditions(RuleCondition ... var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);
    }
}

