/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancersResponse> {
    private final List<LoadBalancer> loadBalancers;
    private final String nextMarker;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        this.loadBalancers = builder.loadBalancers;
        this.nextMarker = builder.nextMarker;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancers() == null ? 0 : this.loadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse)((Object)obj);
        if (other.loadBalancers() == null ^ this.loadBalancers() == null) {
            return false;
        }
        if (other.loadBalancers() != null && !other.loadBalancers().equals(this.loadBalancers())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.loadBalancers()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LoadBalancer> loadBalancers;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            this.setLoadBalancers(model.loadBalancers);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<LoadBalancer> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder nextMarker(String var1);
    }
}

