/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteListenerRequestMarshaller
implements Marshaller<Request<DeleteListenerRequest>, DeleteListenerRequest> {
    public Request<DeleteListenerRequest> marshall(DeleteListenerRequest deleteListenerRequest) {
        if (deleteListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteListenerRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DeleteListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteListenerRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)deleteListenerRequest.listenerArn()));
        }
        return request;
    }
}

