/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateListenerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateListenerRequest> {
    private final String loadBalancerArn;
    private final String protocol;
    private final Integer port;
    private final String sslPolicy;
    private final List<Certificate> certificates;
    private final List<Action> defaultActions;

    private CreateListenerRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public String protocol() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String sslPolicy() {
        return this.sslPolicy;
    }

    public List<Certificate> certificates() {
        return this.certificates;
    }

    public List<Action> defaultActions() {
        return this.defaultActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArn() == null ? 0 : this.loadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.sslPolicy() == null ? 0 : this.sslPolicy().hashCode());
        hashCode = 31 * hashCode + (this.certificates() == null ? 0 : this.certificates().hashCode());
        hashCode = 31 * hashCode + (this.defaultActions() == null ? 0 : this.defaultActions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest)((Object)obj);
        if (other.loadBalancerArn() == null ^ this.loadBalancerArn() == null) {
            return false;
        }
        if (other.loadBalancerArn() != null && !other.loadBalancerArn().equals(this.loadBalancerArn())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.sslPolicy() == null ^ this.sslPolicy() == null) {
            return false;
        }
        if (other.sslPolicy() != null && !other.sslPolicy().equals(this.sslPolicy())) {
            return false;
        }
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.defaultActions() == null ^ this.defaultActions() == null) {
            return false;
        }
        return other.defaultActions() == null || other.defaultActions().equals(this.defaultActions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.sslPolicy() != null) {
            sb.append("SslPolicy: ").append(this.sslPolicy()).append(",");
        }
        if (this.certificates() != null) {
            sb.append("Certificates: ").append(this.certificates()).append(",");
        }
        if (this.defaultActions() != null) {
            sb.append("DefaultActions: ").append(this.defaultActions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String protocol;
        private Integer port;
        private String sslPolicy;
        private List<Certificate> certificates;
        private List<Action> defaultActions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            this.setLoadBalancerArn(model.loadBalancerArn);
            this.setProtocol(model.protocol);
            this.setPort(model.port);
            this.setSslPolicy(model.sslPolicy);
            this.setCertificates(model.certificates);
            this.setDefaultActions(model.defaultActions);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public final Collection<Certificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
        }

        @SafeVarargs
        public final void setCertificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
        }

        public final Collection<Action> getDefaultActions() {
            return this.defaultActions;
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        public final void setDefaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
        }

        @SafeVarargs
        public final void setDefaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
        }

        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateListenerRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder sslPolicy(String var1);

        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder defaultActions(Collection<Action> var1);

        public Builder defaultActions(Action ... var1);
    }
}

