/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CipherUnmarshaller;

public class SslPolicyUnmarshaller
implements Unmarshaller<SslPolicy, StaxUnmarshallerContext> {
    private static final SslPolicyUnmarshaller INSTANCE = new SslPolicyUnmarshaller();

    public SslPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        SslPolicy.Builder sslPolicy;
        block8: {
            sslPolicy = SslPolicy.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> sslProtocols = null;
            ArrayList<Cipher> ciphers = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    sslPolicy.sslProtocols(sslProtocols);
                    sslPolicy.ciphers(ciphers);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SslProtocols", targetDepth)) {
                        sslProtocols = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SslProtocols/member", targetDepth)) {
                        sslProtocols.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Ciphers", targetDepth)) {
                        ciphers = new ArrayList<Cipher>();
                        continue;
                    }
                    if (context.testExpression("Ciphers/member", targetDepth)) {
                        ciphers.add(CipherUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Name", targetDepth)) continue;
                    sslPolicy.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            sslPolicy.sslProtocols(sslProtocols);
            sslPolicy.ciphers(ciphers);
        }
        return (SslPolicy)sslPolicy.build();
    }

    public static SslPolicyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

