/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;

public class SetSubnetsRequestMarshaller
implements Marshaller<Request<SetSubnetsRequest>, SetSubnetsRequest> {
    public Request<SetSubnetsRequest> marshall(SetSubnetsRequest setSubnetsRequest) {
        if (setSubnetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setSubnetsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "SetSubnets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSubnetsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)setSubnetsRequest.loadBalancerArn()));
        }
        if (setSubnetsRequest.subnets().isEmpty() && !(setSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            request.addParameter("Subnets", "");
        } else if (!setSubnetsRequest.subnets().isEmpty() && !(setSubnetsRequest.subnets() instanceof SdkAutoConstructList)) {
            List<String> subnetsList = setSubnetsRequest.subnets();
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringConversion.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        if (setSubnetsRequest.subnetMappings().isEmpty() && !(setSubnetsRequest.subnetMappings() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetMappings", "");
        } else if (!setSubnetsRequest.subnetMappings().isEmpty() && !(setSubnetsRequest.subnetMappings() instanceof SdkAutoConstructList)) {
            List<SubnetMapping> subnetMappingsList = setSubnetsRequest.subnetMappings();
            int subnetMappingsListIndex = 1;
            for (SubnetMapping subnetMappingsListValue : subnetMappingsList) {
                if (subnetMappingsListValue.subnetId() != null) {
                    request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringConversion.fromString((String)subnetMappingsListValue.subnetId()));
                }
                if (subnetMappingsListValue.allocationId() != null) {
                    request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringConversion.fromString((String)subnetMappingsListValue.allocationId()));
                }
                ++subnetMappingsListIndex;
            }
        }
        return request;
    }
}

