/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;

public class SetSecurityGroupsRequestMarshaller
implements Marshaller<Request<SetSecurityGroupsRequest>, SetSecurityGroupsRequest> {
    public Request<SetSecurityGroupsRequest> marshall(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        if (setSecurityGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setSecurityGroupsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "SetSecurityGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSecurityGroupsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)setSecurityGroupsRequest.loadBalancerArn()));
        }
        if (setSecurityGroupsRequest.securityGroups().isEmpty() && !(setSecurityGroupsRequest.securityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!setSecurityGroupsRequest.securityGroups().isEmpty() && !(setSecurityGroupsRequest.securityGroups() instanceof SdkAutoConstructList)) {
            List<String> securityGroupsList = setSecurityGroupsRequest.securityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringConversion.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        return request;
    }
}

