/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;

public class RedirectActionConfigUnmarshaller
implements Unmarshaller<RedirectActionConfig, StaxUnmarshallerContext> {
    private static final RedirectActionConfigUnmarshaller INSTANCE = new RedirectActionConfigUnmarshaller();

    public RedirectActionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RedirectActionConfig.Builder redirectActionConfig = RedirectActionConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Protocol", targetDepth)) {
                    redirectActionConfig.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    redirectActionConfig.port(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Host", targetDepth)) {
                    redirectActionConfig.host(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Path", targetDepth)) {
                    redirectActionConfig.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Query", targetDepth)) {
                    redirectActionConfig.query(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StatusCode", targetDepth)) continue;
                redirectActionConfig.statusCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RedirectActionConfig)redirectActionConfig.build();
    }

    public static RedirectActionConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

