/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;

public class ModifyTargetGroupAttributesRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupAttributesRequest>, ModifyTargetGroupAttributesRequest> {
    public Request<ModifyTargetGroupAttributesRequest> marshall(ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        if (modifyTargetGroupAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyTargetGroupAttributesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "ModifyTargetGroupAttributes");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupAttributesRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringConversion.fromString((String)modifyTargetGroupAttributesRequest.targetGroupArn()));
        }
        if (modifyTargetGroupAttributesRequest.attributes().isEmpty() && !(modifyTargetGroupAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            request.addParameter("Attributes", "");
        } else if (!modifyTargetGroupAttributesRequest.attributes().isEmpty() && !(modifyTargetGroupAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            List<TargetGroupAttribute> attributesList = modifyTargetGroupAttributesRequest.attributes();
            int attributesListIndex = 1;
            for (TargetGroupAttribute attributesListValue : attributesList) {
                if (attributesListValue.key() != null) {
                    request.addParameter("Attributes.member." + attributesListIndex + ".Key", StringConversion.fromString((String)attributesListValue.key()));
                }
                if (attributesListValue.value() != null) {
                    request.addParameter("Attributes.member." + attributesListIndex + ".Value", StringConversion.fromString((String)attributesListValue.value()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

