/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        if (describeLoadBalancersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancersRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancersRequest.loadBalancerArns().isEmpty() && !(describeLoadBalancersRequest.loadBalancerArns() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerArns", "");
        } else if (!describeLoadBalancersRequest.loadBalancerArns().isEmpty() && !(describeLoadBalancersRequest.loadBalancerArns() instanceof SdkAutoConstructList)) {
            List<String> loadBalancerArnsList = describeLoadBalancersRequest.loadBalancerArns();
            int loadBalancerArnsListIndex = 1;
            for (String loadBalancerArnsListValue : loadBalancerArnsList) {
                if (loadBalancerArnsListValue != null) {
                    request.addParameter("LoadBalancerArns.member." + loadBalancerArnsListIndex, StringConversion.fromString((String)loadBalancerArnsListValue));
                }
                ++loadBalancerArnsListIndex;
            }
        }
        if (describeLoadBalancersRequest.names().isEmpty() && !(describeLoadBalancersRequest.names() instanceof SdkAutoConstructList)) {
            request.addParameter("Names", "");
        } else if (!describeLoadBalancersRequest.names().isEmpty() && !(describeLoadBalancersRequest.names() instanceof SdkAutoConstructList)) {
            List<String> namesList = describeLoadBalancersRequest.names();
            int namesListIndex = 1;
            for (String namesListValue : namesList) {
                if (namesListValue != null) {
                    request.addParameter("Names.member." + namesListIndex, StringConversion.fromString((String)namesListValue));
                }
                ++namesListIndex;
            }
        }
        if (describeLoadBalancersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeLoadBalancersRequest.marker()));
        }
        if (describeLoadBalancersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeLoadBalancersRequest.pageSize()));
        }
        return request;
    }
}

