/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class DeregisterTargetsRequestMarshaller
implements Marshaller<Request<DeregisterTargetsRequest>, DeregisterTargetsRequest> {
    public Request<DeregisterTargetsRequest> marshall(DeregisterTargetsRequest deregisterTargetsRequest) {
        if (deregisterTargetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deregisterTargetsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DeregisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deregisterTargetsRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringConversion.fromString((String)deregisterTargetsRequest.targetGroupArn()));
        }
        if (deregisterTargetsRequest.targets().isEmpty() && !(deregisterTargetsRequest.targets() instanceof SdkAutoConstructList)) {
            request.addParameter("Targets", "");
        } else if (!deregisterTargetsRequest.targets().isEmpty() && !(deregisterTargetsRequest.targets() instanceof SdkAutoConstructList)) {
            List<TargetDescription> targetsList = deregisterTargetsRequest.targets();
            int targetsListIndex = 1;
            for (TargetDescription targetsListValue : targetsList) {
                if (targetsListValue.id() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Id", StringConversion.fromString((String)targetsListValue.id()));
                }
                if (targetsListValue.port() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Port", StringConversion.fromInteger((Integer)targetsListValue.port()));
                }
                if (targetsListValue.availabilityZone() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringConversion.fromString((String)targetsListValue.availabilityZone()));
                }
                ++targetsListIndex;
            }
        }
        return request;
    }
}

