/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        if (createListenerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createListenerRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)createListenerRequest.loadBalancerArn()));
        }
        if (createListenerRequest.protocolAsString() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)createListenerRequest.protocolAsString()));
        }
        if (createListenerRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createListenerRequest.port()));
        }
        if (createListenerRequest.sslPolicy() != null) {
            request.addParameter("SslPolicy", StringConversion.fromString((String)createListenerRequest.sslPolicy()));
        }
        if (createListenerRequest.certificates().isEmpty() && !(createListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            request.addParameter("Certificates", "");
        } else if (!createListenerRequest.certificates().isEmpty() && !(createListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            List<Certificate> certificatesList = createListenerRequest.certificates();
            int certificatesListIndex = 1;
            for (Certificate certificatesListValue : certificatesList) {
                if (certificatesListValue.certificateArn() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringConversion.fromString((String)certificatesListValue.certificateArn()));
                }
                if (certificatesListValue.isDefault() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringConversion.fromBoolean((Boolean)certificatesListValue.isDefault()));
                }
                ++certificatesListIndex;
            }
        }
        if (createListenerRequest.defaultActions().isEmpty() && !(createListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            request.addParameter("DefaultActions", "");
        } else if (!createListenerRequest.defaultActions().isEmpty() && !(createListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            List<Action> defaultActionsList = createListenerRequest.defaultActions();
            int defaultActionsListIndex = 1;
            for (Action defaultActionsListValue : defaultActionsList) {
                FixedResponseActionConfig fixedResponseConfig;
                RedirectActionConfig redirectConfig;
                AuthenticateCognitoActionConfig authenticateCognitoConfig;
                AuthenticateOidcActionConfig authenticateOidcConfig;
                if (defaultActionsListValue.typeAsString() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringConversion.fromString((String)defaultActionsListValue.typeAsString()));
                }
                if (defaultActionsListValue.targetGroupArn() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)defaultActionsListValue.targetGroupArn()));
                }
                if ((authenticateOidcConfig = defaultActionsListValue.authenticateOidcConfig()) != null) {
                    Map<String, String> authenticationRequestExtraParams;
                    if (authenticateOidcConfig.issuer() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Issuer", StringConversion.fromString((String)authenticateOidcConfig.issuer()));
                    }
                    if (authenticateOidcConfig.authorizationEndpoint() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringConversion.fromString((String)authenticateOidcConfig.authorizationEndpoint()));
                    }
                    if (authenticateOidcConfig.tokenEndpoint() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringConversion.fromString((String)authenticateOidcConfig.tokenEndpoint()));
                    }
                    if (authenticateOidcConfig.userInfoEndpoint() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringConversion.fromString((String)authenticateOidcConfig.userInfoEndpoint()));
                    }
                    if (authenticateOidcConfig.clientId() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientId", StringConversion.fromString((String)authenticateOidcConfig.clientId()));
                    }
                    if (authenticateOidcConfig.clientSecret() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringConversion.fromString((String)authenticateOidcConfig.clientSecret()));
                    }
                    if (authenticateOidcConfig.sessionCookieName() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringConversion.fromString((String)authenticateOidcConfig.sessionCookieName()));
                    }
                    if (authenticateOidcConfig.scope() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Scope", StringConversion.fromString((String)authenticateOidcConfig.scope()));
                    }
                    if (authenticateOidcConfig.sessionTimeout() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringConversion.fromLong((Long)authenticateOidcConfig.sessionTimeout()));
                    }
                    if ((authenticationRequestExtraParams = authenticateOidcConfig.authenticationRequestExtraParams()) != null) {
                        int authenticationRequestExtraParamsListIndex = 1;
                        for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                            if (entry.getKey() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                            }
                            if (entry.getValue() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                            }
                            ++authenticationRequestExtraParamsListIndex;
                        }
                    }
                    if (authenticateOidcConfig.onUnauthenticatedRequestAsString() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringConversion.fromString((String)authenticateOidcConfig.onUnauthenticatedRequestAsString()));
                    }
                }
                if ((authenticateCognitoConfig = defaultActionsListValue.authenticateCognitoConfig()) != null) {
                    Map<String, String> authenticationRequestExtraParams;
                    if (authenticateCognitoConfig.userPoolArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringConversion.fromString((String)authenticateCognitoConfig.userPoolArn()));
                    }
                    if (authenticateCognitoConfig.userPoolClientId() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringConversion.fromString((String)authenticateCognitoConfig.userPoolClientId()));
                    }
                    if (authenticateCognitoConfig.userPoolDomain() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringConversion.fromString((String)authenticateCognitoConfig.userPoolDomain()));
                    }
                    if (authenticateCognitoConfig.sessionCookieName() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringConversion.fromString((String)authenticateCognitoConfig.sessionCookieName()));
                    }
                    if (authenticateCognitoConfig.scope() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.Scope", StringConversion.fromString((String)authenticateCognitoConfig.scope()));
                    }
                    if (authenticateCognitoConfig.sessionTimeout() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringConversion.fromLong((Long)authenticateCognitoConfig.sessionTimeout()));
                    }
                    if ((authenticationRequestExtraParams = authenticateCognitoConfig.authenticationRequestExtraParams()) != null) {
                        int authenticationRequestExtraParamsListIndex = 1;
                        for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                            if (entry.getKey() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                            }
                            if (entry.getValue() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                            }
                            ++authenticationRequestExtraParamsListIndex;
                        }
                    }
                    if (authenticateCognitoConfig.onUnauthenticatedRequestAsString() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringConversion.fromString((String)authenticateCognitoConfig.onUnauthenticatedRequestAsString()));
                    }
                }
                if (defaultActionsListValue.order() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Order", StringConversion.fromInteger((Integer)defaultActionsListValue.order()));
                }
                if ((redirectConfig = defaultActionsListValue.redirectConfig()) != null) {
                    if (redirectConfig.protocol() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Protocol", StringConversion.fromString((String)redirectConfig.protocol()));
                    }
                    if (redirectConfig.port() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Port", StringConversion.fromString((String)redirectConfig.port()));
                    }
                    if (redirectConfig.host() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Host", StringConversion.fromString((String)redirectConfig.host()));
                    }
                    if (redirectConfig.path() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Path", StringConversion.fromString((String)redirectConfig.path()));
                    }
                    if (redirectConfig.query() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Query", StringConversion.fromString((String)redirectConfig.query()));
                    }
                    if (redirectConfig.statusCodeAsString() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.StatusCode", StringConversion.fromString((String)redirectConfig.statusCodeAsString()));
                    }
                }
                if ((fixedResponseConfig = defaultActionsListValue.fixedResponseConfig()) != null) {
                    if (fixedResponseConfig.messageBody() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.MessageBody", StringConversion.fromString((String)fixedResponseConfig.messageBody()));
                    }
                    if (fixedResponseConfig.statusCode() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.StatusCode", StringConversion.fromString((String)fixedResponseConfig.statusCode()));
                    }
                    if (fixedResponseConfig.contentType() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.ContentType", StringConversion.fromString((String)fixedResponseConfig.contentType()));
                    }
                }
                ++defaultActionsListIndex;
            }
        }
        return request;
    }
}

