/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;

public class CertificateUnmarshaller
implements Unmarshaller<Certificate, StaxUnmarshallerContext> {
    private static final CertificateUnmarshaller INSTANCE = new CertificateUnmarshaller();

    public Certificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Certificate.Builder certificate = Certificate.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CertificateArn", targetDepth)) {
                    certificate.certificateArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsDefault", targetDepth)) continue;
                certificate.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Certificate)certificate.build();
    }

    public static CertificateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

