/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addTagsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "AddTags");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addTagsRequest.resourceArns().isEmpty() && !(addTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ResourceArns", "");
        } else if (!addTagsRequest.resourceArns().isEmpty() && !(addTagsRequest.resourceArns() instanceof SdkAutoConstructList)) {
            List<String> resourceArnsList = addTagsRequest.resourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringConversion.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (addTagsRequest.tags().isEmpty() && !(addTagsRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!addTagsRequest.tags().isEmpty() && !(addTagsRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = addTagsRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

