/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AuthenticateCognitoActionConfigUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AuthenticateOidcActionConfigUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.FixedResponseActionConfigUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RedirectActionConfigUnmarshaller;

public class ActionUnmarshaller
implements Unmarshaller<Action, StaxUnmarshallerContext> {
    private static final ActionUnmarshaller INSTANCE = new ActionUnmarshaller();

    public Action unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Action.Builder action = Action.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Type", targetDepth)) {
                    action.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetGroupArn", targetDepth)) {
                    action.targetGroupArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AuthenticateOidcConfig", targetDepth)) {
                    action.authenticateOidcConfig(AuthenticateOidcActionConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AuthenticateCognitoConfig", targetDepth)) {
                    action.authenticateCognitoConfig(AuthenticateCognitoActionConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Order", targetDepth)) {
                    action.order(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RedirectConfig", targetDepth)) {
                    action.redirectConfig(RedirectActionConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("FixedResponseConfig", targetDepth)) continue;
                action.fixedResponseConfig(FixedResponseActionConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Action)action.build();
    }

    public static ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

