/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetMapping
implements ToCopyableBuilder<Builder, SubnetMapping> {
    private final String subnetId;
    private final String allocationId;

    private SubnetMapping(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.allocationId = builder.allocationId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetMapping)) {
            return false;
        }
        SubnetMapping other = (SubnetMapping)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.allocationId(), other.allocationId());
    }

    public String toString() {
        return ToString.builder((String)"SubnetMapping").add("SubnetId", (Object)this.subnetId()).add("AllocationId", (Object)this.allocationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String allocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetMapping model) {
            this.subnetId(model.subnetId);
            this.allocationId(model.allocationId);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public SubnetMapping build() {
            return new SubnetMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubnetMapping> {
        public Builder subnetId(String var1);

        public Builder allocationId(String var1);
    }
}

