/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CiphersCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslProtocolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SslPolicy
implements ToCopyableBuilder<Builder, SslPolicy> {
    private final List<String> sslProtocols;
    private final List<Cipher> ciphers;
    private final String name;

    private SslPolicy(BuilderImpl builder) {
        this.sslProtocols = builder.sslProtocols;
        this.ciphers = builder.ciphers;
        this.name = builder.name;
    }

    public List<String> sslProtocols() {
        return this.sslProtocols;
    }

    public List<Cipher> ciphers() {
        return this.ciphers;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sslProtocols());
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphers());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy)obj;
        return Objects.equals(this.sslProtocols(), other.sslProtocols()) && Objects.equals(this.ciphers(), other.ciphers()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"SslPolicy").add("SslProtocols", this.sslProtocols()).add("Ciphers", this.ciphers()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SslProtocols": {
                return Optional.ofNullable(clazz.cast(this.sslProtocols()));
            }
            case "Ciphers": {
                return Optional.ofNullable(clazz.cast(this.ciphers()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sslProtocols = DefaultSdkAutoConstructList.getInstance();
        private List<Cipher> ciphers = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SslPolicy model) {
            this.sslProtocols(model.sslProtocols);
            this.ciphers(model.ciphers);
            this.name(model.name);
        }

        public final Collection<String> getSslProtocols() {
            return this.sslProtocols;
        }

        @Override
        public final Builder sslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslProtocols(String ... sslProtocols) {
            this.sslProtocols(Arrays.asList(sslProtocols));
            return this;
        }

        public final void setSslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
        }

        public final Collection<Cipher.Builder> getCiphers() {
            return this.ciphers != null ? (Collection)this.ciphers.stream().map(Cipher::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ciphers(Collection<Cipher> ciphers) {
            this.ciphers = CiphersCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Cipher ... ciphers) {
            this.ciphers(Arrays.asList(ciphers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Consumer<Cipher.Builder> ... ciphers) {
            this.ciphers(Stream.of(ciphers).map(c -> (Cipher)((Cipher.Builder)Cipher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCiphers(Collection<Cipher.BuilderImpl> ciphers) {
            this.ciphers = CiphersCopier.copyFromBuilder(ciphers);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public SslPolicy build() {
            return new SslPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SslPolicy> {
        public Builder sslProtocols(Collection<String> var1);

        public Builder sslProtocols(String ... var1);

        public Builder ciphers(Collection<Cipher> var1);

        public Builder ciphers(Cipher ... var1);

        public Builder ciphers(Consumer<Cipher.Builder> ... var1);

        public Builder name(String var1);
    }
}

