/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancer
implements ToCopyableBuilder<Builder, LoadBalancer> {
    private final String loadBalancerArn;
    private final String dnsName;
    private final String canonicalHostedZoneId;
    private final Instant createdTime;
    private final String loadBalancerName;
    private final String scheme;
    private final String vpcId;
    private final LoadBalancerState state;
    private final String type;
    private final List<AvailabilityZone> availabilityZones;
    private final List<String> securityGroups;
    private final String ipAddressType;

    private LoadBalancer(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.loadBalancerName = builder.loadBalancerName;
        this.scheme = builder.scheme;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.type = builder.type;
        this.availabilityZones = builder.availabilityZones;
        this.securityGroups = builder.securityGroups;
        this.ipAddressType = builder.ipAddressType;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String canonicalHostedZoneId() {
        return this.canonicalHostedZoneId;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(this.scheme);
    }

    public String schemeAsString() {
        return this.scheme;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public LoadBalancerState state() {
        return this.state;
    }

    public LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.canonicalHostedZoneId(), other.canonicalHostedZoneId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.schemeAsString(), other.schemeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancer").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("DNSName", (Object)this.dnsName()).add("CanonicalHostedZoneId", (Object)this.canonicalHostedZoneId()).add("CreatedTime", (Object)this.createdTime()).add("LoadBalancerName", (Object)this.loadBalancerName()).add("Scheme", (Object)this.schemeAsString()).add("VpcId", (Object)this.vpcId()).add("State", (Object)this.state()).add("Type", (Object)this.typeAsString()).add("AvailabilityZones", this.availabilityZones()).add("SecurityGroups", this.securityGroups()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "CanonicalHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.schemeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String dnsName;
        private String canonicalHostedZoneId;
        private Instant createdTime;
        private String loadBalancerName;
        private String scheme;
        private String vpcId;
        private LoadBalancerState state;
        private String type;
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.dnsName(model.dnsName);
            this.canonicalHostedZoneId(model.canonicalHostedZoneId);
            this.createdTime(model.createdTime);
            this.loadBalancerName(model.loadBalancerName);
            this.scheme(model.scheme);
            this.vpcId(model.vpcId);
            this.state(model.state);
            this.type(model.type);
            this.availabilityZones(model.availabilityZones);
            this.securityGroups(model.securityGroups);
            this.ipAddressType(model.ipAddressType);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getCanonicalHostedZoneId() {
            return this.canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final LoadBalancerState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final void setState(LoadBalancerState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancer> {
        public Builder loadBalancerArn(String var1);

        public Builder dnsName(String var1);

        public Builder canonicalHostedZoneId(String var1);

        public Builder createdTime(Instant var1);

        public Builder loadBalancerName(String var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder vpcId(String var1);

        public Builder state(LoadBalancerState var1);

        default public Builder state(Consumer<LoadBalancerState.Builder> state) {
            return this.state((LoadBalancerState)((LoadBalancerState.Builder)LoadBalancerState.builder().applyMutation(state)).build());
        }

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);
    }
}

