/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;

public class SetIpAddressTypeRequestMarshaller
implements Marshaller<Request<SetIpAddressTypeRequest>, SetIpAddressTypeRequest> {
    public Request<SetIpAddressTypeRequest> marshall(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        if (setIpAddressTypeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setIpAddressTypeRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "SetIpAddressType");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIpAddressTypeRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)setIpAddressTypeRequest.loadBalancerArn()));
        }
        if (setIpAddressTypeRequest.ipAddressTypeAsString() != null) {
            request.addParameter("IpAddressType", StringConversion.fromString((String)setIpAddressTypeRequest.ipAddressTypeAsString()));
        }
        return request;
    }
}

