/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AvailabilityZoneUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.LoadBalancerStateUnmarshaller;

public class LoadBalancerUnmarshaller
implements Unmarshaller<LoadBalancer, StaxUnmarshallerContext> {
    private static final LoadBalancerUnmarshaller INSTANCE = new LoadBalancerUnmarshaller();

    public LoadBalancer unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadBalancer.Builder loadBalancer;
        block17: {
            loadBalancer = LoadBalancer.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<AvailabilityZone> availabilityZones = null;
            ArrayList<String> securityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    loadBalancer.availabilityZones(availabilityZones);
                    loadBalancer.securityGroups(securityGroups);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("LoadBalancerArn", targetDepth)) {
                        loadBalancer.loadBalancerArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DNSName", targetDepth)) {
                        loadBalancer.dnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CanonicalHostedZoneId", targetDepth)) {
                        loadBalancer.canonicalHostedZoneId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreatedTime", targetDepth)) {
                        loadBalancer.createdTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LoadBalancerName", targetDepth)) {
                        loadBalancer.loadBalancerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Scheme", targetDepth)) {
                        loadBalancer.scheme(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        loadBalancer.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("State", targetDepth)) {
                        loadBalancer.state(LoadBalancerStateUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Type", targetDepth)) {
                        loadBalancer.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones", targetDepth)) {
                        availabilityZones = new ArrayList<AvailabilityZone>();
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                        availabilityZones.add(AvailabilityZoneUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SecurityGroups", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SecurityGroups/member", targetDepth)) {
                        securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("IpAddressType", targetDepth)) continue;
                    loadBalancer.ipAddressType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            loadBalancer.availabilityZones(availabilityZones);
            loadBalancer.securityGroups(securityGroups);
        }
        return (LoadBalancer)loadBalancer.build();
    }

    public static LoadBalancerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

