/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;

public class DescribeRulesRequestMarshaller
implements Marshaller<Request<DescribeRulesRequest>, DescribeRulesRequest> {
    public Request<DescribeRulesRequest> marshall(DescribeRulesRequest describeRulesRequest) {
        if (describeRulesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeRulesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeRules");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeRulesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)describeRulesRequest.listenerArn()));
        }
        if (describeRulesRequest.ruleArns().isEmpty() && !(describeRulesRequest.ruleArns() instanceof SdkAutoConstructList)) {
            request.addParameter("RuleArns", "");
        } else if (!describeRulesRequest.ruleArns().isEmpty() && !(describeRulesRequest.ruleArns() instanceof SdkAutoConstructList)) {
            List<String> ruleArnsList = describeRulesRequest.ruleArns();
            int ruleArnsListIndex = 1;
            for (String ruleArnsListValue : ruleArnsList) {
                if (ruleArnsListValue != null) {
                    request.addParameter("RuleArns.member." + ruleArnsListIndex, StringConversion.fromString((String)ruleArnsListValue));
                }
                ++ruleArnsListIndex;
            }
        }
        if (describeRulesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeRulesRequest.marker()));
        }
        if (describeRulesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeRulesRequest.pageSize()));
        }
        return request;
    }
}

