/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        if (createLoadBalancerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLoadBalancerRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createLoadBalancerRequest.name()));
        }
        if (createLoadBalancerRequest.subnets().isEmpty() && !(createLoadBalancerRequest.subnets() instanceof SdkAutoConstructList)) {
            request.addParameter("Subnets", "");
        } else if (!createLoadBalancerRequest.subnets().isEmpty() && !(createLoadBalancerRequest.subnets() instanceof SdkAutoConstructList)) {
            List<String> subnetsList = createLoadBalancerRequest.subnets();
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringConversion.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        if (createLoadBalancerRequest.subnetMappings().isEmpty() && !(createLoadBalancerRequest.subnetMappings() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetMappings", "");
        } else if (!createLoadBalancerRequest.subnetMappings().isEmpty() && !(createLoadBalancerRequest.subnetMappings() instanceof SdkAutoConstructList)) {
            List<SubnetMapping> subnetMappingsList = createLoadBalancerRequest.subnetMappings();
            int subnetMappingsListIndex = 1;
            for (SubnetMapping subnetMappingsListValue : subnetMappingsList) {
                if (subnetMappingsListValue.subnetId() != null) {
                    request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringConversion.fromString((String)subnetMappingsListValue.subnetId()));
                }
                if (subnetMappingsListValue.allocationId() != null) {
                    request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringConversion.fromString((String)subnetMappingsListValue.allocationId()));
                }
                ++subnetMappingsListIndex;
            }
        }
        if (createLoadBalancerRequest.securityGroups().isEmpty() && !(createLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!createLoadBalancerRequest.securityGroups().isEmpty() && !(createLoadBalancerRequest.securityGroups() instanceof SdkAutoConstructList)) {
            List<String> securityGroupsList = createLoadBalancerRequest.securityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringConversion.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLoadBalancerRequest.schemeAsString() != null) {
            request.addParameter("Scheme", StringConversion.fromString((String)createLoadBalancerRequest.schemeAsString()));
        }
        if (createLoadBalancerRequest.tags().isEmpty() && !(createLoadBalancerRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createLoadBalancerRequest.tags().isEmpty() && !(createLoadBalancerRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createLoadBalancerRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createLoadBalancerRequest.typeAsString() != null) {
            request.addParameter("Type", StringConversion.fromString((String)createLoadBalancerRequest.typeAsString()));
        }
        if (createLoadBalancerRequest.ipAddressTypeAsString() != null) {
            request.addParameter("IpAddressType", StringConversion.fromString((String)createLoadBalancerRequest.ipAddressTypeAsString()));
        }
        return request;
    }
}

