/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;

public class AuthenticateCognitoActionConfigUnmarshaller
implements Unmarshaller<AuthenticateCognitoActionConfig, StaxUnmarshallerContext> {
    private static final AuthenticateCognitoActionConfigUnmarshaller INSTANCE = new AuthenticateCognitoActionConfigUnmarshaller();

    public AuthenticateCognitoActionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        AuthenticateCognitoActionConfig.Builder authenticateCognitoActionConfig;
        block12: {
            authenticateCognitoActionConfig = AuthenticateCognitoActionConfig.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            HashMap<String, String> authenticationRequestExtraParams = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    authenticateCognitoActionConfig.authenticationRequestExtraParams(authenticationRequestExtraParams);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("UserPoolArn", targetDepth)) {
                        authenticateCognitoActionConfig.userPoolArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserPoolClientId", targetDepth)) {
                        authenticateCognitoActionConfig.userPoolClientId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserPoolDomain", targetDepth)) {
                        authenticateCognitoActionConfig.userPoolDomain(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SessionCookieName", targetDepth)) {
                        authenticateCognitoActionConfig.sessionCookieName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Scope", targetDepth)) {
                        authenticateCognitoActionConfig.scope(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SessionTimeout", targetDepth)) {
                        authenticateCognitoActionConfig.sessionTimeout(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AuthenticationRequestExtraParams/entry", targetDepth)) {
                        if (authenticationRequestExtraParams == null) {
                            authenticationRequestExtraParams = new HashMap<String, String>();
                        }
                        Map.Entry<String, String> entry = AuthenticationRequestExtraParamsMapEntryUnmarshaller.getInstance().unmarshall(context);
                        authenticationRequestExtraParams.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (!context.testExpression("OnUnauthenticatedRequest", targetDepth)) continue;
                    authenticateCognitoActionConfig.onUnauthenticatedRequest(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            authenticateCognitoActionConfig.authenticationRequestExtraParams(authenticationRequestExtraParams);
        }
        return (AuthenticateCognitoActionConfig)authenticateCognitoActionConfig.build();
    }

    public static AuthenticateCognitoActionConfigUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class AuthenticationRequestExtraParamsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final AuthenticationRequestExtraParamsMapEntryUnmarshaller INSTANCE = new AuthenticationRequestExtraParamsMapEntryUnmarshaller();

        private AuthenticationRequestExtraParamsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AuthenticationRequestExtraParamsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

