/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;

public class AddListenerCertificatesRequestMarshaller
implements Marshaller<Request<AddListenerCertificatesRequest>, AddListenerCertificatesRequest> {
    public Request<AddListenerCertificatesRequest> marshall(AddListenerCertificatesRequest addListenerCertificatesRequest) {
        if (addListenerCertificatesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addListenerCertificatesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "AddListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addListenerCertificatesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)addListenerCertificatesRequest.listenerArn()));
        }
        if (addListenerCertificatesRequest.certificates().isEmpty() && !(addListenerCertificatesRequest.certificates() instanceof SdkAutoConstructList)) {
            request.addParameter("Certificates", "");
        } else if (!addListenerCertificatesRequest.certificates().isEmpty() && !(addListenerCertificatesRequest.certificates() instanceof SdkAutoConstructList)) {
            List<Certificate> certificatesList = addListenerCertificatesRequest.certificates();
            int certificatesListIndex = 1;
            for (Certificate certificatesListValue : certificatesList) {
                if (certificatesListValue.certificateArn() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringConversion.fromString((String)certificatesListValue.certificateArn()));
                }
                if (certificatesListValue.isDefault() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringConversion.fromBoolean((Boolean)certificatesListValue.isDefault()));
                }
                ++certificatesListIndex;
            }
        }
        return request;
    }
}

