/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedirectActionConfig
implements ToCopyableBuilder<Builder, RedirectActionConfig> {
    private final String protocol;
    private final String port;
    private final String host;
    private final String path;
    private final String query;
    private final String statusCode;

    private RedirectActionConfig(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.host = builder.host;
        this.path = builder.path;
        this.query = builder.query;
        this.statusCode = builder.statusCode;
    }

    public String protocol() {
        return this.protocol;
    }

    public String port() {
        return this.port;
    }

    public String host() {
        return this.host;
    }

    public String path() {
        return this.path;
    }

    public String query() {
        return this.query;
    }

    public RedirectActionStatusCodeEnum statusCode() {
        return RedirectActionStatusCodeEnum.fromValue(this.statusCode);
    }

    public String statusCodeAsString() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectActionConfig)) {
            return false;
        }
        RedirectActionConfig other = (RedirectActionConfig)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"RedirectActionConfig").add("Protocol", (Object)this.protocol()).add("Port", (Object)this.port()).add("Host", (Object)this.host()).add("Path", (Object)this.path()).add("Query", (Object)this.query()).add("StatusCode", (Object)this.statusCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private String port;
        private String host;
        private String path;
        private String query;
        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RedirectActionConfig model) {
            this.protocol(model.protocol);
            this.port(model.port);
            this.host(model.host);
            this.path(model.path);
            this.query(model.query);
            this.statusCode(model.statusCode);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getPort() {
            return this.port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(RedirectActionStatusCodeEnum statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public RedirectActionConfig build() {
            return new RedirectActionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedirectActionConfig> {
        public Builder protocol(String var1);

        public Builder port(String var1);

        public Builder host(String var1);

        public Builder path(String var1);

        public Builder query(String var1);

        public Builder statusCode(String var1);

        public Builder statusCode(RedirectActionStatusCodeEnum var1);
    }
}

