/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionAuthenticationRequestExtraParamsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticateOidcActionConfig
implements ToCopyableBuilder<Builder, AuthenticateOidcActionConfig> {
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final String sessionCookieName;
    private final String scope;
    private final Long sessionTimeout;
    private final Map<String, String> authenticationRequestExtraParams;
    private final String onUnauthenticatedRequest;

    private AuthenticateOidcActionConfig(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
    }

    public String issuer() {
        return this.issuer;
    }

    public String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String userInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String sessionCookieName() {
        return this.sessionCookieName;
    }

    public String scope() {
        return this.scope;
    }

    public Long sessionTimeout() {
        return this.sessionTimeout;
    }

    public Map<String, String> authenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams;
    }

    public AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateOidcActionConditionalBehaviorEnum.fromValue(this.onUnauthenticatedRequest);
    }

    public String onUnauthenticatedRequestAsString() {
        return this.onUnauthenticatedRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationRequestExtraParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.onUnauthenticatedRequestAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateOidcActionConfig)) {
            return false;
        }
        AuthenticateOidcActionConfig other = (AuthenticateOidcActionConfig)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.sessionCookieName(), other.sessionCookieName()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout()) && Objects.equals(this.authenticationRequestExtraParams(), other.authenticationRequestExtraParams()) && Objects.equals(this.onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString());
    }

    public String toString() {
        return ToString.builder((String)"AuthenticateOidcActionConfig").add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserInfoEndpoint", (Object)this.userInfoEndpoint()).add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)this.clientSecret()).add("SessionCookieName", (Object)this.sessionCookieName()).add("Scope", (Object)this.scope()).add("SessionTimeout", (Object)this.sessionTimeout()).add("AuthenticationRequestExtraParams", this.authenticationRequestExtraParams()).add("OnUnauthenticatedRequest", (Object)this.onUnauthenticatedRequestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "UserInfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userInfoEndpoint()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "SessionCookieName": {
                return Optional.ofNullable(clazz.cast(this.sessionCookieName()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
            case "AuthenticationRequestExtraParams": {
                return Optional.ofNullable(clazz.cast(this.authenticationRequestExtraParams()));
            }
            case "OnUnauthenticatedRequest": {
                return Optional.ofNullable(clazz.cast(this.onUnauthenticatedRequestAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private String clientId;
        private String clientSecret;
        private String sessionCookieName;
        private String scope;
        private Long sessionTimeout;
        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();
        private String onUnauthenticatedRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateOidcActionConfig model) {
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userInfoEndpoint(model.userInfoEndpoint);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.sessionCookieName(model.sessionCookieName);
            this.scope(model.scope);
            this.sessionTimeout(model.sessionTimeout);
            this.authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            this.onUnauthenticatedRequest(model.onUnauthenticatedRequest);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Long getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
            return this;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
        }

        public final String getOnUnauthenticatedRequest() {
            return this.onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest.toString());
            return this;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        public AuthenticateOidcActionConfig build() {
            return new AuthenticateOidcActionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthenticateOidcActionConfig> {
        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder userInfoEndpoint(String var1);

        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder sessionCookieName(String var1);

        public Builder scope(String var1);

        public Builder sessionTimeout(Long var1);

        public Builder authenticationRequestExtraParams(Map<String, String> var1);

        public Builder onUnauthenticatedRequest(String var1);

        public Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum var1);
    }
}

