/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticateCognitoActionConfig
implements ToCopyableBuilder<Builder, AuthenticateCognitoActionConfig> {
    private final String userPoolArn;
    private final String userPoolClientId;
    private final String userPoolDomain;
    private final String sessionCookieName;
    private final String scope;
    private final Long sessionTimeout;
    private final Map<String, String> authenticationRequestExtraParams;
    private final String onUnauthenticatedRequest;

    private AuthenticateCognitoActionConfig(BuilderImpl builder) {
        this.userPoolArn = builder.userPoolArn;
        this.userPoolClientId = builder.userPoolClientId;
        this.userPoolDomain = builder.userPoolDomain;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
    }

    public String userPoolArn() {
        return this.userPoolArn;
    }

    public String userPoolClientId() {
        return this.userPoolClientId;
    }

    public String userPoolDomain() {
        return this.userPoolDomain;
    }

    public String sessionCookieName() {
        return this.sessionCookieName;
    }

    public String scope() {
        return this.scope;
    }

    public Long sessionTimeout() {
        return this.sessionTimeout;
    }

    public Map<String, String> authenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams;
    }

    public AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateCognitoActionConditionalBehaviorEnum.fromValue(this.onUnauthenticatedRequest);
    }

    public String onUnauthenticatedRequestAsString() {
        return this.onUnauthenticatedRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationRequestExtraParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.onUnauthenticatedRequestAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateCognitoActionConfig)) {
            return false;
        }
        AuthenticateCognitoActionConfig other = (AuthenticateCognitoActionConfig)obj;
        return Objects.equals(this.userPoolArn(), other.userPoolArn()) && Objects.equals(this.userPoolClientId(), other.userPoolClientId()) && Objects.equals(this.userPoolDomain(), other.userPoolDomain()) && Objects.equals(this.sessionCookieName(), other.sessionCookieName()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout()) && Objects.equals(this.authenticationRequestExtraParams(), other.authenticationRequestExtraParams()) && Objects.equals(this.onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString());
    }

    public String toString() {
        return ToString.builder((String)"AuthenticateCognitoActionConfig").add("UserPoolArn", (Object)this.userPoolArn()).add("UserPoolClientId", (Object)this.userPoolClientId()).add("UserPoolDomain", (Object)this.userPoolDomain()).add("SessionCookieName", (Object)this.sessionCookieName()).add("Scope", (Object)this.scope()).add("SessionTimeout", (Object)this.sessionTimeout()).add("AuthenticationRequestExtraParams", this.authenticationRequestExtraParams()).add("OnUnauthenticatedRequest", (Object)this.onUnauthenticatedRequestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolArn": {
                return Optional.ofNullable(clazz.cast(this.userPoolArn()));
            }
            case "UserPoolClientId": {
                return Optional.ofNullable(clazz.cast(this.userPoolClientId()));
            }
            case "UserPoolDomain": {
                return Optional.ofNullable(clazz.cast(this.userPoolDomain()));
            }
            case "SessionCookieName": {
                return Optional.ofNullable(clazz.cast(this.sessionCookieName()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
            case "AuthenticationRequestExtraParams": {
                return Optional.ofNullable(clazz.cast(this.authenticationRequestExtraParams()));
            }
            case "OnUnauthenticatedRequest": {
                return Optional.ofNullable(clazz.cast(this.onUnauthenticatedRequestAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolArn;
        private String userPoolClientId;
        private String userPoolDomain;
        private String sessionCookieName;
        private String scope;
        private Long sessionTimeout;
        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();
        private String onUnauthenticatedRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateCognitoActionConfig model) {
            this.userPoolArn(model.userPoolArn);
            this.userPoolClientId(model.userPoolClientId);
            this.userPoolDomain(model.userPoolDomain);
            this.sessionCookieName(model.sessionCookieName);
            this.scope(model.scope);
            this.sessionTimeout(model.sessionTimeout);
            this.authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            this.onUnauthenticatedRequest(model.onUnauthenticatedRequest);
        }

        public final String getUserPoolArn() {
            return this.userPoolArn;
        }

        @Override
        public final Builder userPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
            return this;
        }

        public final void setUserPoolArn(String userPoolArn) {
            this.userPoolArn = userPoolArn;
        }

        public final String getUserPoolClientId() {
            return this.userPoolClientId;
        }

        @Override
        public final Builder userPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
            return this;
        }

        public final void setUserPoolClientId(String userPoolClientId) {
            this.userPoolClientId = userPoolClientId;
        }

        public final String getUserPoolDomain() {
            return this.userPoolDomain;
        }

        @Override
        public final Builder userPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
            return this;
        }

        public final void setUserPoolDomain(String userPoolDomain) {
            this.userPoolDomain = userPoolDomain;
        }

        public final String getSessionCookieName() {
            return this.sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Long getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            return this.authenticationRequestExtraParams;
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
            return this;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateCognitoActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
        }

        public final String getOnUnauthenticatedRequest() {
            return this.onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest.toString());
            return this;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        public AuthenticateCognitoActionConfig build() {
            return new AuthenticateCognitoActionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthenticateCognitoActionConfig> {
        public Builder userPoolArn(String var1);

        public Builder userPoolClientId(String var1);

        public Builder userPoolDomain(String var1);

        public Builder sessionCookieName(String var1);

        public Builder scope(String var1);

        public Builder sessionTimeout(Long var1);

        public Builder authenticationRequestExtraParams(Map<String, String> var1);

        public Builder onUnauthenticatedRequest(String var1);

        public Builder onUnauthenticatedRequest(AuthenticateCognitoActionConditionalBehaviorEnum var1);
    }
}

