/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements ToCopyableBuilder<Builder, Action> {
    private final String type;
    private final String targetGroupArn;
    private final AuthenticateOidcActionConfig authenticateOidcConfig;
    private final AuthenticateCognitoActionConfig authenticateCognitoConfig;
    private final Integer order;
    private final RedirectActionConfig redirectConfig;
    private final FixedResponseActionConfig fixedResponseConfig;

    private Action(BuilderImpl builder) {
        this.type = builder.type;
        this.targetGroupArn = builder.targetGroupArn;
        this.authenticateOidcConfig = builder.authenticateOidcConfig;
        this.authenticateCognitoConfig = builder.authenticateCognitoConfig;
        this.order = builder.order;
        this.redirectConfig = builder.redirectConfig;
        this.fixedResponseConfig = builder.fixedResponseConfig;
    }

    public ActionTypeEnum type() {
        return ActionTypeEnum.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public AuthenticateOidcActionConfig authenticateOidcConfig() {
        return this.authenticateOidcConfig;
    }

    public AuthenticateCognitoActionConfig authenticateCognitoConfig() {
        return this.authenticateCognitoConfig;
    }

    public Integer order() {
        return this.order;
    }

    public RedirectActionConfig redirectConfig() {
        return this.redirectConfig;
    }

    public FixedResponseActionConfig fixedResponseConfig() {
        return this.fixedResponseConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateOidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticateCognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedResponseConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.authenticateOidcConfig(), other.authenticateOidcConfig()) && Objects.equals(this.authenticateCognitoConfig(), other.authenticateCognitoConfig()) && Objects.equals(this.order(), other.order()) && Objects.equals(this.redirectConfig(), other.redirectConfig()) && Objects.equals(this.fixedResponseConfig(), other.fixedResponseConfig());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("Type", (Object)this.typeAsString()).add("TargetGroupArn", (Object)this.targetGroupArn()).add("AuthenticateOidcConfig", (Object)this.authenticateOidcConfig()).add("AuthenticateCognitoConfig", (Object)this.authenticateCognitoConfig()).add("Order", (Object)this.order()).add("RedirectConfig", (Object)this.redirectConfig()).add("FixedResponseConfig", (Object)this.fixedResponseConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "AuthenticateOidcConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticateOidcConfig()));
            }
            case "AuthenticateCognitoConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticateCognitoConfig()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "RedirectConfig": {
                return Optional.ofNullable(clazz.cast(this.redirectConfig()));
            }
            case "FixedResponseConfig": {
                return Optional.ofNullable(clazz.cast(this.fixedResponseConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String targetGroupArn;
        private AuthenticateOidcActionConfig authenticateOidcConfig;
        private AuthenticateCognitoActionConfig authenticateCognitoConfig;
        private Integer order;
        private RedirectActionConfig redirectConfig;
        private FixedResponseActionConfig fixedResponseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.type(model.type);
            this.targetGroupArn(model.targetGroupArn);
            this.authenticateOidcConfig(model.authenticateOidcConfig);
            this.authenticateCognitoConfig(model.authenticateCognitoConfig);
            this.order(model.order);
            this.redirectConfig(model.redirectConfig);
            this.fixedResponseConfig(model.fixedResponseConfig);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final AuthenticateOidcActionConfig.Builder getAuthenticateOidcConfig() {
            return this.authenticateOidcConfig != null ? this.authenticateOidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateOidcConfig(AuthenticateOidcActionConfig authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig;
            return this;
        }

        public final void setAuthenticateOidcConfig(AuthenticateOidcActionConfig.BuilderImpl authenticateOidcConfig) {
            this.authenticateOidcConfig = authenticateOidcConfig != null ? authenticateOidcConfig.build() : null;
        }

        public final AuthenticateCognitoActionConfig.Builder getAuthenticateCognitoConfig() {
            return this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.toBuilder() : null;
        }

        @Override
        public final Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig;
            return this;
        }

        public final void setAuthenticateCognitoConfig(AuthenticateCognitoActionConfig.BuilderImpl authenticateCognitoConfig) {
            this.authenticateCognitoConfig = authenticateCognitoConfig != null ? authenticateCognitoConfig.build() : null;
        }

        public final Integer getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final RedirectActionConfig.Builder getRedirectConfig() {
            return this.redirectConfig != null ? this.redirectConfig.toBuilder() : null;
        }

        @Override
        public final Builder redirectConfig(RedirectActionConfig redirectConfig) {
            this.redirectConfig = redirectConfig;
            return this;
        }

        public final void setRedirectConfig(RedirectActionConfig.BuilderImpl redirectConfig) {
            this.redirectConfig = redirectConfig != null ? redirectConfig.build() : null;
        }

        public final FixedResponseActionConfig.Builder getFixedResponseConfig() {
            return this.fixedResponseConfig != null ? this.fixedResponseConfig.toBuilder() : null;
        }

        @Override
        public final Builder fixedResponseConfig(FixedResponseActionConfig fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig;
            return this;
        }

        public final void setFixedResponseConfig(FixedResponseActionConfig.BuilderImpl fixedResponseConfig) {
            this.fixedResponseConfig = fixedResponseConfig != null ? fixedResponseConfig.build() : null;
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Action> {
        public Builder type(String var1);

        public Builder type(ActionTypeEnum var1);

        public Builder targetGroupArn(String var1);

        public Builder authenticateOidcConfig(AuthenticateOidcActionConfig var1);

        default public Builder authenticateOidcConfig(Consumer<AuthenticateOidcActionConfig.Builder> authenticateOidcConfig) {
            return this.authenticateOidcConfig((AuthenticateOidcActionConfig)((AuthenticateOidcActionConfig.Builder)AuthenticateOidcActionConfig.builder().applyMutation(authenticateOidcConfig)).build());
        }

        public Builder authenticateCognitoConfig(AuthenticateCognitoActionConfig var1);

        default public Builder authenticateCognitoConfig(Consumer<AuthenticateCognitoActionConfig.Builder> authenticateCognitoConfig) {
            return this.authenticateCognitoConfig((AuthenticateCognitoActionConfig)((AuthenticateCognitoActionConfig.Builder)AuthenticateCognitoActionConfig.builder().applyMutation(authenticateCognitoConfig)).build());
        }

        public Builder order(Integer var1);

        public Builder redirectConfig(RedirectActionConfig var1);

        default public Builder redirectConfig(Consumer<RedirectActionConfig.Builder> redirectConfig) {
            return this.redirectConfig((RedirectActionConfig)((RedirectActionConfig.Builder)RedirectActionConfig.builder().applyMutation(redirectConfig)).build());
        }

        public Builder fixedResponseConfig(FixedResponseActionConfig var1);

        default public Builder fixedResponseConfig(Consumer<FixedResponseActionConfig.Builder> fixedResponseConfig) {
            return this.fixedResponseConfig((FixedResponseActionConfig)((FixedResponseActionConfig.Builder)FixedResponseActionConfig.builder().applyMutation(fixedResponseConfig)).build());
        }
    }
}

