/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        if (modifyLoadBalancerAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyLoadBalancerAttributesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)modifyLoadBalancerAttributesRequest.loadBalancerArn()));
        }
        if (modifyLoadBalancerAttributesRequest.attributes().isEmpty() && !(modifyLoadBalancerAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            request.addParameter("Attributes", "");
        } else if (!modifyLoadBalancerAttributesRequest.attributes().isEmpty() && !(modifyLoadBalancerAttributesRequest.attributes() instanceof SdkAutoConstructList)) {
            List<LoadBalancerAttribute> attributesList = modifyLoadBalancerAttributesRequest.attributes();
            int attributesListIndex = 1;
            for (LoadBalancerAttribute attributesListValue : attributesList) {
                if (attributesListValue.key() != null) {
                    request.addParameter("Attributes.member." + attributesListIndex + ".Key", StringConversion.fromString((String)attributesListValue.key()));
                }
                if (attributesListValue.value() != null) {
                    request.addParameter("Attributes.member." + attributesListIndex + ".Value", StringConversion.fromString((String)attributesListValue.value()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

