/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;

public class DescribeSslPoliciesRequestMarshaller
implements Marshaller<Request<DescribeSslPoliciesRequest>, DescribeSslPoliciesRequest> {
    public Request<DescribeSslPoliciesRequest> marshall(DescribeSslPoliciesRequest describeSslPoliciesRequest) {
        if (describeSslPoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSslPoliciesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeSSLPolicies");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSslPoliciesRequest.names().isEmpty() && !(describeSslPoliciesRequest.names() instanceof SdkAutoConstructList)) {
            request.addParameter("Names", "");
        } else if (!describeSslPoliciesRequest.names().isEmpty() && !(describeSslPoliciesRequest.names() instanceof SdkAutoConstructList)) {
            List<String> namesList = describeSslPoliciesRequest.names();
            int namesListIndex = 1;
            for (String namesListValue : namesList) {
                if (namesListValue != null) {
                    request.addParameter("Names.member." + namesListIndex, StringConversion.fromString((String)namesListValue));
                }
                ++namesListIndex;
            }
        }
        if (describeSslPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeSslPoliciesRequest.marker()));
        }
        if (describeSslPoliciesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeSslPoliciesRequest.pageSize()));
        }
        return request;
    }
}

