/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;

public class DescribeListenersRequestMarshaller
implements Marshaller<Request<DescribeListenersRequest>, DescribeListenersRequest> {
    public Request<DescribeListenersRequest> marshall(DescribeListenersRequest describeListenersRequest) {
        if (describeListenersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeListenersRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeListeners");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeListenersRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)describeListenersRequest.loadBalancerArn()));
        }
        if (describeListenersRequest.listenerArns().isEmpty() && !(describeListenersRequest.listenerArns() instanceof SdkAutoConstructList)) {
            request.addParameter("ListenerArns", "");
        } else if (!describeListenersRequest.listenerArns().isEmpty() && !(describeListenersRequest.listenerArns() instanceof SdkAutoConstructList)) {
            List<String> listenerArnsList = describeListenersRequest.listenerArns();
            int listenerArnsListIndex = 1;
            for (String listenerArnsListValue : listenerArnsList) {
                if (listenerArnsListValue != null) {
                    request.addParameter("ListenerArns.member." + listenerArnsListIndex, StringConversion.fromString((String)listenerArnsListValue));
                }
                ++listenerArnsListIndex;
            }
        }
        if (describeListenersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeListenersRequest.marker()));
        }
        if (describeListenersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeListenersRequest.pageSize()));
        }
        return request;
    }
}

