/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class CreateRuleRequestMarshaller
implements Marshaller<Request<CreateRuleRequest>, CreateRuleRequest> {
    public Request<CreateRuleRequest> marshall(CreateRuleRequest createRuleRequest) {
        if (createRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createRuleRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRuleRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)createRuleRequest.listenerArn()));
        }
        if (createRuleRequest.conditions().isEmpty() && !(createRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            request.addParameter("Conditions", "");
        } else if (!createRuleRequest.conditions().isEmpty() && !(createRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            List<RuleCondition> conditionsList = createRuleRequest.conditions();
            int conditionsListIndex = 1;
            for (RuleCondition conditionsListValue : conditionsList) {
                if (conditionsListValue.field() != null) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringConversion.fromString((String)conditionsListValue.field()));
                }
                if (conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                } else if (!conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = conditionsListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++conditionsListIndex;
            }
        }
        if (createRuleRequest.priority() != null) {
            request.addParameter("Priority", StringConversion.fromInteger((Integer)createRuleRequest.priority()));
        }
        if (createRuleRequest.actions().isEmpty() && !(createRuleRequest.actions() instanceof SdkAutoConstructList)) {
            request.addParameter("Actions", "");
        } else if (!createRuleRequest.actions().isEmpty() && !(createRuleRequest.actions() instanceof SdkAutoConstructList)) {
            List<Action> actionsList = createRuleRequest.actions();
            int actionsListIndex = 1;
            for (Action actionsListValue : actionsList) {
                if (actionsListValue.typeAsString() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".Type", StringConversion.fromString((String)actionsListValue.typeAsString()));
                }
                if (actionsListValue.targetGroupArn() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)actionsListValue.targetGroupArn()));
                }
                ++actionsListIndex;
            }
        }
        return request;
    }
}

