/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;

public class DescribeTargetGroupsIterable
implements SdkIterable<DescribeTargetGroupsResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeTargetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTargetGroupsIterable(ElasticLoadBalancingV2Client client, DescribeTargetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTargetGroupsResponseFetcher();
    }

    public Iterator<DescribeTargetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TargetGroup> targetGroups() {
        Function<DescribeTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetGroups() != null) {
                return response.targetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeTargetGroupsIterable resume(DescribeTargetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTargetGroupsIterable(this.client, (DescribeTargetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeTargetGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeTargetGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeTargetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeTargetGroupsResponse> {
        private DescribeTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTargetGroupsResponse previousPage) {
            return previousPage.nextMarker() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextMarker()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextMarker());
        }

        public DescribeTargetGroupsResponse nextPage(DescribeTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTargetGroupsIterable.this.client.describeTargetGroups(DescribeTargetGroupsIterable.this.firstRequest);
            }
            return DescribeTargetGroupsIterable.this.client.describeTargetGroups((DescribeTargetGroupsRequest)((Object)DescribeTargetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

