/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;

public class SetRulePrioritiesRequestMarshaller
implements Marshaller<Request<SetRulePrioritiesRequest>, SetRulePrioritiesRequest> {
    public Request<SetRulePrioritiesRequest> marshall(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        if (setRulePrioritiesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setRulePrioritiesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "SetRulePriorities");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setRulePrioritiesRequest.rulePriorities().isEmpty() && !(setRulePrioritiesRequest.rulePriorities() instanceof SdkAutoConstructList)) {
            request.addParameter("RulePriorities", "");
        } else if (!setRulePrioritiesRequest.rulePriorities().isEmpty() && !(setRulePrioritiesRequest.rulePriorities() instanceof SdkAutoConstructList)) {
            List<RulePriorityPair> rulePrioritiesList = setRulePrioritiesRequest.rulePriorities();
            int rulePrioritiesListIndex = 1;
            for (RulePriorityPair rulePrioritiesListValue : rulePrioritiesList) {
                if (rulePrioritiesListValue.ruleArn() != null) {
                    request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".RuleArn", StringConversion.fromString((String)rulePrioritiesListValue.ruleArn()));
                }
                if (rulePrioritiesListValue.priority() != null) {
                    request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".Priority", StringConversion.fromInteger((Integer)rulePrioritiesListValue.priority()));
                }
                ++rulePrioritiesListIndex;
            }
        }
        return request;
    }
}

