/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;

public class ModifyListenerRequestMarshaller
implements Marshaller<Request<ModifyListenerRequest>, ModifyListenerRequest> {
    public Request<ModifyListenerRequest> marshall(ModifyListenerRequest modifyListenerRequest) {
        if (modifyListenerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyListenerRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "ModifyListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyListenerRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)modifyListenerRequest.listenerArn()));
        }
        if (modifyListenerRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)modifyListenerRequest.port()));
        }
        if (modifyListenerRequest.protocolAsString() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)modifyListenerRequest.protocolAsString()));
        }
        if (modifyListenerRequest.sslPolicy() != null) {
            request.addParameter("SslPolicy", StringConversion.fromString((String)modifyListenerRequest.sslPolicy()));
        }
        if (modifyListenerRequest.certificates().isEmpty() && !(modifyListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            request.addParameter("Certificates", "");
        } else if (!modifyListenerRequest.certificates().isEmpty() && !(modifyListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            List<Certificate> certificatesList = modifyListenerRequest.certificates();
            int certificatesListIndex = 1;
            for (Certificate certificatesListValue : certificatesList) {
                if (certificatesListValue.certificateArn() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringConversion.fromString((String)certificatesListValue.certificateArn()));
                }
                if (certificatesListValue.isDefault() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringConversion.fromBoolean((Boolean)certificatesListValue.isDefault()));
                }
                ++certificatesListIndex;
            }
        }
        if (modifyListenerRequest.defaultActions().isEmpty() && !(modifyListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            request.addParameter("DefaultActions", "");
        } else if (!modifyListenerRequest.defaultActions().isEmpty() && !(modifyListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            List<Action> defaultActionsList = modifyListenerRequest.defaultActions();
            int defaultActionsListIndex = 1;
            for (Action defaultActionsListValue : defaultActionsList) {
                if (defaultActionsListValue.typeAsString() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringConversion.fromString((String)defaultActionsListValue.typeAsString()));
                }
                if (defaultActionsListValue.targetGroupArn() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)defaultActionsListValue.targetGroupArn()));
                }
                ++defaultActionsListIndex;
            }
        }
        return request;
    }
}

