/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        if (createListenerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createListenerRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)createListenerRequest.loadBalancerArn()));
        }
        if (createListenerRequest.protocolAsString() != null) {
            request.addParameter("Protocol", StringConversion.fromString((String)createListenerRequest.protocolAsString()));
        }
        if (createListenerRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createListenerRequest.port()));
        }
        if (createListenerRequest.sslPolicy() != null) {
            request.addParameter("SslPolicy", StringConversion.fromString((String)createListenerRequest.sslPolicy()));
        }
        if (createListenerRequest.certificates().isEmpty() && !(createListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            request.addParameter("Certificates", "");
        } else if (!createListenerRequest.certificates().isEmpty() && !(createListenerRequest.certificates() instanceof SdkAutoConstructList)) {
            List<Certificate> certificatesList = createListenerRequest.certificates();
            int certificatesListIndex = 1;
            for (Certificate certificatesListValue : certificatesList) {
                if (certificatesListValue.certificateArn() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringConversion.fromString((String)certificatesListValue.certificateArn()));
                }
                if (certificatesListValue.isDefault() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringConversion.fromBoolean((Boolean)certificatesListValue.isDefault()));
                }
                ++certificatesListIndex;
            }
        }
        if (createListenerRequest.defaultActions().isEmpty() && !(createListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            request.addParameter("DefaultActions", "");
        } else if (!createListenerRequest.defaultActions().isEmpty() && !(createListenerRequest.defaultActions() instanceof SdkAutoConstructList)) {
            List<Action> defaultActionsList = createListenerRequest.defaultActions();
            int defaultActionsListIndex = 1;
            for (Action defaultActionsListValue : defaultActionsList) {
                if (defaultActionsListValue.typeAsString() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringConversion.fromString((String)defaultActionsListValue.typeAsString()));
                }
                if (defaultActionsListValue.targetGroupArn() != null) {
                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)defaultActionsListValue.targetGroupArn()));
                }
                ++defaultActionsListIndex;
            }
        }
        return request;
    }
}

